@echo off

rem Syntax
rem  Arg 1 = project name
rem  Arg 2 (optional) = build configuration
rem  Arg 3 (optional) = package name

set ANDROID_SDK=%PUBLIC%\Documents\Embarcadero\Studio\19.0\PlatformSDKs\android-sdk-windows
set ADB=%ANDROID_SDK%\platform-tools\adb.exe
set FQ_PROJECT=%~f1
set PROJECT_DIR=%~p1
set PROJECT_NAME=%~n1
set PACKAGE_NAME=com.blong.%PROJECT_NAME%
set CONFIG=Debug

if X%1 == X goto syntax

if not exist %1 (
  echo Cannot locate project %FQ_PROJECT%
  goto :EOF
)

if not X%2 == X (
  if "%2" == "Release" set CONFIG=Release
)

if not X%3 == X set PACKAGE_NAME=%3

pushd %PROJECT_DIR%

echo.&echo Building %PROJECT_NAME%.dproj&echo.

msbuild %PROJECT_NAME%.dproj /p:Config=%CONFIG% /p:Platform=Android /t:Make || goto build_error

echo.&echo Deploying %PROJECT_NAME%.dproj&echo.

msbuild %PROJECT_NAME%.dproj /p:Config=%CONFIG% /p:Platform=Android /t:Deploy || goto deploy_error

echo.&echo Installing Android package, %PROJECT_NAME%.apk&echo.

%ADB% install -r Android\%CONFIG%\%PROJECT_NAME%\bin\%PROJECT_NAME%.apk || goto install_error

echo.&echo Launching Android app, %PACKAGE_NAME%&echo.

%ADB% -d shell am start -a android.intent.action.MAIN -n %PACKAGE_NAME%/com.embarcadero.firemonkey.FMXNativeActivity || goto launch_error

echo.&echo Done!

goto bye

:syntax

echo BuildAndDeploy syntax:
echo.
echo   BuildAndDeploy ^<DelphiProjectFile^> [^<Configuration^> [^<AndroidPackageName^>]]
echo.
echo where:
echo.
echo ^<DelphiprojectFile^> is a Delphi project.dproj file
echo ^<Configuration^> is the required build configuration, Release or Debug, which defaults to Debug
echo ^<AndroidPackageName^> is the Android package name for the project, in case it is different from com.blong.project
goto bye

:build_error

echo Problem encountered while build the Android lib%PROJECT_NAME%.so native library
goto bye

:deploy_error

echo Problem encountered while creating the %PROJECT_NAME%.apk Android package
goto bye

:install_error

echo Problem encountered while installing %PROJECT_NAME%.apk
goto bye

:launch_error

echo Problem encountered while launching %PROJECT_NAME%.apk
goto bye

:bye
popd
